%--------------------------------------------------------------------------
% Program     : Rugosity by boxcounting (LerDoc.m)

% Written by  : Maysa Macedo

% email       : marcelo_at_cbpf.br ; maysagm_at_cbpf.br, dario_at_cbpf.br;
% albuquer_at_cbpf.br, luizlima_at_metalmat.ufrj.br

% Copyright(): Centro Brasileiro de Pesquisas Fisicas - CBPF/MCT/Rio de Janeiro/Brazil

% Version     : 06_11_01

% Objective   : Rugosity Computing

% Compiler    : Matlab 7.1- R4-SP3

% Project     : -

% Authors     : Maysa Macedo, Dario oliveira, Marcelo Portes de Albquerque,
% Marcio Portes de Albuquerque, Luiz Lima

% Mode        : In Matlab 7.1- R4-SP3 prompt, at the current directory, you should execute the comand:
% main;

% Comments    : This program is distributed in the hope that it will be useful,
%                but WITHOUT ANY WARRANTY; without even the implied warranty of
%                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. It is
%                FREEWARE.  
%Funo LerDoc l um arquivo ASCII gerado pelo programa TOPOSPM


function [EstruturaImagem] = LerDoc(Arquivo,tipoLeitura,respInput)
 warning off;
 EstruturaImagem = struct( 'imagem',{0},...
                           'version',{0},...
                           'datetime',{0},   'description',{0},     'dataoffset',{0},    'stagetype',{0},...
                           'probetype',{0},  'scannerserialnum',{0},'experimenttype',{0},'datatype',{0},...
                           'calibration',{0},'zgain',{0},           'imagesize',{0},     'imageresolution',{0},...
                           'datarange',{0},  'scanrate',{0},        'scandirection',{0}, 'rotation',{0},...
                           'pidsettings',{0},'relativesetpoint',{0},'samplebias',{0},    'zunit',{0});
                       
 if (tipoLeitura==1)
     EstruturaImagem = LerDocAccurex(Arquivo);
 elseif (tipoLeitura==2)
     EstruturaImagem = LerDocJpk(Arquivo);
 elseif (tipoLeitura==3) 
    EstruturaImagem =LerDocBMP(Arquivo,respInput) ; 
 end
 
              
%--------------------------------------------------------------------------


function [EstruturaImagem] = LerDocAccurex(Arquivo)
 warning off;
 EstruturaImagem = struct( 'imagem',{0},...
                           'version',{0},...
                           'datetime',{0},   'description',{0},     'dataoffset',{0},    'stagetype',{0},...
                           'probetype',{0},  'scannerserialnum',{0},'experimenttype',{0},'datatype',{0},...
                           'calibration',{0},'zgain',{0},           'imagesize',{0},     'imageresolution',{0},...
                           'datarange',{0},  'scanrate',{0},        'scandirection',{0}, 'rotation',{0},...
                           'pidsettings',{0},'relativesetpoint',{0},'samplebias',{0},    'zunit',{0});
               
% [Dados Value]= textread(Arquivo, '%s %s', 'delimiter','=','bufsize',25500);
% NumRecords = length(Dados)-1;
% 
% 
% 
% EstruturaImagem.version=char(Value(2));
% EstruturaImagem.datatime=char(Value(3));
% EstruturaImagem.description=char(Value(4));
% EstruturaImagem.dataoffset=char(Value(5));
% EstruturaImagem.stagetype=char(Value(6));
% EstruturaImagem.probetype=char(Value(7));
% EstruturaImagem.scannerserialnum=char(Value(8));
% EstruturaImagem.experimenttype=char(Value(9));
% EstruturaImagem.datatype=char(Value(10));
% EstruturaImagem.calibration=char(Value(11));
% EstruturaImagem.zgain=char(Value(12));
% EstruturaImagem.imagesize=char(Value(13));
% EstruturaImagem.imageresolution=char(Value(14));
% EstruturaImagem.datarange=char(Value(15));
% EstruturaImagem.scanrate=char(Value(16));
% EstruturaImagem.scandirection=char(Value(17));
% EstruturaImagem.rotation=char(Value(18));
% EstruturaImagem.pidsettings=char(Value(19));
% EstruturaImagem.relativesetpoint=char(Value(20));
% EstruturaImagem.samplebias=char(Value(21));
% EstruturaImagem.zunit=char(Value(22));

[ValorImagem] = textread(Arquivo, '%s', 'delimiter', '\t','bufsize',25500);
NumRecordsImagem = length(ValorImagem)-1;

p=strfind(char(ValorImagem(2)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.version=char(ValorImagem(2));EstruturaImagem.version=EstruturaImagem.version(p(1)+1:end);
p=strfind(char(ValorImagem(3)),'=');;if (numel(p)==0)p=1;end 
EstruturaImagem.datatime=char(ValorImagem(3));EstruturaImagem.datatime=EstruturaImagem.datatime(p(1)+1:end);
p=strfind(char(ValorImagem(4)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.description=char(ValorImagem(4));EstruturaImagem.description=EstruturaImagem.description(p(1)+1:end);
p=strfind(char(ValorImagem(5)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.dataoffset=char(ValorImagem(5));EstruturaImagem.dataoffset=EstruturaImagem.dataoffset(p(1)+1:end);
p=strfind(char(ValorImagem(6)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.stagetype=char(ValorImagem(6));EstruturaImagem.stagetype=EstruturaImagem.stagetype(p(1)+1:end);
p=strfind(char(ValorImagem(7)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.probetype=char(ValorImagem(7));EstruturaImagem.probetype=EstruturaImagem.probetype(p(1)+1:end);
p=strfind(char(ValorImagem(8)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.scannerserialnum=char(ValorImagem(8));EstruturaImagem.scannerserialnum=EstruturaImagem.scannerserialnum(p(1)+1:end);
p=strfind(char(ValorImagem(9)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.experimenttype=char(ValorImagem(9));EstruturaImagem.experimenttype=EstruturaImagem.experimenttype(p(1)+1:end);
p=strfind(char(ValorImagem(10)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.datatype=char(ValorImagem(10));EstruturaImagem.datatype=EstruturaImagem.datatype(p(1)+1:end);
p=strfind(char(ValorImagem(11)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.calibration=char(ValorImagem(11));EstruturaImagem.calibration=EstruturaImagem.calibration(p(1)+1:end);
p=strfind(char(ValorImagem(12)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.zgain=char(ValorImagem(12));EstruturaImagem.zgain=EstruturaImagem.zgain(p(1)+1:end);
p=strfind(char(ValorImagem(13)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.imagesize=char(ValorImagem(13));EstruturaImagem.imagesize=EstruturaImagem.imagesize(p(1)+1:end);
p=strfind(char(ValorImagem(14)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.imageresolution=char(ValorImagem(14));EstruturaImagem.imageresolution=EstruturaImagem.imageresolution(p(1)+1:end);
p=strfind(char(ValorImagem(15)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.datarange=char(ValorImagem(15));EstruturaImagem.datarange=EstruturaImagem.datarange(p(1)+1:end);
p=strfind(char(ValorImagem(16)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.scanrate=char(ValorImagem(16));EstruturaImagem.scanrate=EstruturaImagem.scanrate(p(1)+1:end);
p=strfind(char(ValorImagem(17)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.scandirection=char(ValorImagem(17));EstruturaImagem.scandirection=EstruturaImagem.scandirection(p(1)+1:end);
p=strfind(char(ValorImagem(18)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.rotation=char(ValorImagem(18));EstruturaImagem.rotation=EstruturaImagem.rotation(p(1)+1:end);
p=strfind(char(ValorImagem(19)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.pidsettings=char(ValorImagem(19));EstruturaImagem.pidsettings=EstruturaImagem.pidsettings(p(1)+1:end);
p=strfind(char(ValorImagem(20)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.relativesetpoint=char(ValorImagem(20));EstruturaImagem.relativesetpoint=EstruturaImagem.relativesetpoint(p(1)+1:end);
p=strfind(char(ValorImagem(21)),'=');if (numel(p)==0)p=1;end 
EstruturaImagem.samplebias=char(ValorImagem(21));EstruturaImagem.samplebias=EstruturaImagem.samplebias(p(1)+1:end);
p=strfind(char(ValorImagem(23)),':');
EstruturaImagem.zunit=char(ValorImagem(23));EstruturaImagem.zunit=EstruturaImagem.zunit(p(1)+1:end);

ponteiro    = findstr(EstruturaImagem.imageresolution,' x');
EstruturaImagem.imageresolution  = EstruturaImagem.imageresolution(1:ponteiro-1); %Resolucao da imagem (numero de pixels por linha)
ponteiro    = findstr(EstruturaImagem.imagesize,' ');
EstruturaImagem.imagesize     = EstruturaImagem.imagesize(1:ponteiro-1); %Tamanho da imagem em microns ou nanometro


%A imagem comea em 24
CellImagem = str2num(char(ValorImagem(24:end)));
resolucao  = str2num(EstruturaImagem.imageresolution);

for i=0:resolucao-1
    MatImagem(i+1,:) = CellImagem((i*resolucao+1):(i+1)*resolucao);
end

EstruturaImagem.imagem = MatImagem;
%imshow(MatImagem,'DisplayRange',[-127 255]);
clear ponteiro ;clear CellImagem;clear MatImagem;clear resolucao;clear ValorImagem;clear p;clear NumRecordsImagem;
%--------------------------------------------------------------------------


function [EstruturaImagemx] = LerDocJpk(Arquivo)
 warning off;
 EstruturaImagemx = struct( 'imagem',{0},...
                           'channel',{0},...
                           'direction',{0},   'Comment',{0},     'scanNumber',{0},    'bottomUp',{0},...
                           'fastSize',{0},  'slowSize',{0},'xOffset',{0},'yOffset',{0},...
                           'iLength',{0},'jLength',{0},           'theta',{0},     'reflect',{0},...
                           'scanRate',{0},  'dutyCycle',{0},        'delay',{0}, 'feedbackMode',{0},...
                           'tipsaverSetpoint',{0},'tipsaverActive',{0},'tipsaverLowerLimit',{0},...
                           'isAdjustReference',{0},...
                           'referenceAmplitude',{0}, 'sineAmplitude',{0}, 'sineFrequency',{0}, 'sinePhaseShift',{0},...
                           'iGain',{0}, 'pGain',{0}, 'setpoint',{0}, 'scanner',{0}, 'startdate',{0}, 'enddate',{0},...
                           'CalibrationSlot',{0}, 'zunit',{0}, 'imagesize',{0},'imageresolution',{0});
 
                       
                       
 
 
% [Dados Value]= textread(Arquivo, '%s %s', 'delimiter',':','bufsize',25500);
% NumRecords = length(Dados)-1;
% 
% 
% EstruturaImagem.channel=char(Value(1));
% EstruturaImagem.direction=char(Value(2));
% EstruturaImagem.Comment=strcat(char(Value(3)),strcat(' _ ',strcat(char(Dados(4)),strcat(' _ ',strcat(char(Value(4)),char(Dados(5)))))));;
% EstruturaImagem.scanNumber=char(Value(6));
% EstruturaImagem.bottomUp=char(Value(7));
% EstruturaImagem.fastSize=char(Value(8));
% EstruturaImagem.slowSize=char(Value(9));
% EstruturaImagem.xOffset=char(Value(10));
% EstruturaImagem.yOffset=char(Value(11));
% EstruturaImagem.iLength=char(Value(12));
% EstruturaImagem.jLength=char(Value(13));
% EstruturaImagem.theta=char(Value(14));
% EstruturaImagem.reflect=char(Value(15));
% EstruturaImagem.scanRate=char(Value(16));
% EstruturaImagem.dutyCycle=char(Value(17));
% EstruturaImagem.delay=char(Value(18));
% EstruturaImagem.feedbackMode=char(Value(19));
% EstruturaImagem.tipsaverSetpoint=char(Value(20));
% EstruturaImagem.tipsaverActive=char(Value(21));
% EstruturaImagem.tipsaverLowerLimit=char(Value(22));
% EstruturaImagem.isAdjustReference=char(Value(23));
% EstruturaImagem.referenceAmplitude=char(Value(24));
% EstruturaImagem.sineAmplitude=char(Value(25));
% EstruturaImagem.sineFrequency=char(Value(26));
% EstruturaImagem.sinePhaseShift=char(Value(27));
% EstruturaImagem.iGain=char(Value(28));
% EstruturaImagem.pGain=char(Value(29));
% EstruturaImagem.setpoint=char(Value(30));
% EstruturaImagem.scanner=char(Value(31));
% EstruturaImagem.startdate=strcat(char(Value(32)),strcat(char(Dados(33)),strcat(char(Value(33)),char(Dados(34)))));
% EstruturaImagem.enddate=strcat(char(Value(35)),strcat(char(Dados(36)),strcat(char(Value(36)),char(Dados(37)))));
% EstruturaImagem.CalibrationSlot=char(Value(38));
% EstruturaImagem.Unit=char(Value(39));
% 

 [ValorImagem] = textread(Arquivo, '%s', 'delimiter', '\t','bufsize',25500);
 NumRecordsImagem = length(ValorImagem)-1;

 
p(1)=1;p=strfind(char(ValorImagem(1)),':');
EstruturaImagemx.channel=char(ValorImagem(1));EstruturaImagemx.channel=EstruturaImagemx.channel(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(2)),':');
EstruturaImagemx.direction=char(ValorImagem(2));EstruturaImagemx.direction=EstruturaImagemx.direction(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(3)),':');
EstruturaImagemx.Comment=char(ValorImagem(3));EstruturaImagemx.Comment=EstruturaImagemx.Comment(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(4)),':');
EstruturaImagemx.scanNumber=char(ValorImagem(4));EstruturaImagemx.scanNumber=EstruturaImagemx.scanNumber(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(5)),':');
EstruturaImagemx.bottomUp=char(ValorImagem(5));EstruturaImagemx.bottomUp=EstruturaImagemx.bottomUp(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(6)),':');
EstruturaImagemx.fastSize=char(ValorImagem(6));EstruturaImagemx.fastSize=EstruturaImagemx.fastSize(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(7)),':');
EstruturaImagemx.slowSize=char(ValorImagem(7));EstruturaImagemx.slowSize=EstruturaImagemx.slowSize(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(8)),':');
EstruturaImagemx.xOffset=char(ValorImagem(8));EstruturaImagemx.xOffset=EstruturaImagemx.xOffset(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(9)),':');
EstruturaImagemx.yOffset=char(ValorImagem(9));EstruturaImagemx.yOffset=EstruturaImagemx.yOffset(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(10)),':');
EstruturaImagemx.iLength=char(ValorImagem(10));EstruturaImagemx.iLength=EstruturaImagemx.iLength(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(11)),':');
EstruturaImagemx.jLength=char(ValorImagem(11));EstruturaImagemx.jLength=EstruturaImagemx.jLength(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(12)),':');
EstruturaImagemx.theta=char(ValorImagem(12));EstruturaImagemx.theta=EstruturaImagemx.theta(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(13)),':');
EstruturaImagemx.reflect=char(ValorImagem(13));EstruturaImagemx.reflect=EstruturaImagemx.reflect(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(14)),':');
EstruturaImagemx.scanRate=char(ValorImagem(14));EstruturaImagemx.scanRate=EstruturaImagemx.scanRate(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(15)),':');
EstruturaImagemx.dutyCycle=char(ValorImagem(15));EstruturaImagemx.dutyCycle=EstruturaImagemx.dutyCycle(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(16)),':');
EstruturaImagemx.delay=char(ValorImagem(16));EstruturaImagemx.delay=EstruturaImagemx.delay(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(17)),':');
EstruturaImagemx.feedbackMode=char(ValorImagem(17));EstruturaImagemx.feedbackMode=EstruturaImagemx.feedbackMode(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(18)),':');
EstruturaImagemx.tipsaverSetpoint=char(ValorImagem(18));EstruturaImagemx.tipsaverSetpoint=EstruturaImagemx.tipsaverSetpoint(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(19)),':');
EstruturaImagemx.tipsaverActive=char(ValorImagem(19));EstruturaImagemx.tipsaverActive=EstruturaImagemx.tipsaverActive(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(20)),':');
EstruturaImagemx.tipsaverLowerLimit=char(ValorImagem(20));EstruturaImagemx.tipsaverLowerLimit=EstruturaImagemx.tipsaverLowerLimit(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(21)),':');
EstruturaImagemx.isAdjustReference=char(ValorImagem(21));EstruturaImagemx.isAdjustReference=EstruturaImagemx.isAdjustReference(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(22)),':');
EstruturaImagemx.referenceAmplitude=char(ValorImagem(22));EstruturaImagemx.referenceAmplitude=EstruturaImagemx.referenceAmplitude(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(23)),':');
EstruturaImagemx.sineAmplitude=char(ValorImagem(23));EstruturaImagemx.sineAmplitude=EstruturaImagemx.sineAmplitude(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(24)),':');
EstruturaImagemx.sineFrequency=char(ValorImagem(24));EstruturaImagemx.sineFrequency=EstruturaImagemx.sineFrequency(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(25)),':');
EstruturaImagemx.sinePhaseShift=char(ValorImagem(25));EstruturaImagemx.sinePhaseShift=EstruturaImagemx.sinePhaseShift(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(26)),':');
EstruturaImagemx.iGain=char(ValorImagem(26));EstruturaImagemx.iGain=EstruturaImagemx.iGain(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(27)),':');
EstruturaImagemx.pGain=char(ValorImagem(27));EstruturaImagemx.pGain=EstruturaImagemx.pGain(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(28)),':');
EstruturaImagemx.setpoint=char(ValorImagem(28));EstruturaImagemx.setpoint=EstruturaImagemx.setpoint(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(29)),':');
EstruturaImagemx.scanner=char(ValorImagem(29));EstruturaImagemx.scanner=EstruturaImagemx.scanner(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(30)),':');
EstruturaImagemx.startdate=char(ValorImagem(30));EstruturaImagemx.startdate=EstruturaImagemx.startdate(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(31)),':');
EstruturaImagemx.enddate=char(ValorImagem(31));EstruturaImagemx.enddate=EstruturaImagemx.enddate(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(32)),':');
EstruturaImagemx.CalibrationSlot=char(ValorImagem(32));EstruturaImagemx.CalibrationSlot=EstruturaImagemx.CalibrationSlot(p(1)+2:end);
p(1)=1;p=strfind(char(ValorImagem(33)),':');
EstruturaImagemx.zunit=char(ValorImagem(33));EstruturaImagemx.zunit=EstruturaImagemx.zunit(p(1)+2:end);
EstruturaImagemx.imagesize=EstruturaImagemx.fastSize;
EstruturaImagemx.imageresolution=str2num(EstruturaImagemx.iLength);

 clear ValorImagem


% %A imagem comea em 41



 [ValorImagem] = textread(Arquivo, '%s', 'delimiter', ' ','bufsize',270000);
 NumRecordsImagem = length(ValorImagem)-1;
 

 CellImagem = str2num(char(ValorImagem(120:end)));
 resolucao=str2num(EstruturaImagemx.iLength);
 for i=0:resolucao-1
     MatImagem(i+1,:) = CellImagem((i*resolucao+1):(i+1)*resolucao);
 end

 EstruturaImagemx.imagem = MatImagem.*(10^9);
% %imshow(MatImagem,'DisplayRange',[-127 255]);
clear MatImagem;clear resolucao;clear ValorImagem;clear NumRecordsImagem;

%--------------------------------------------------------------------------
function [EstruturaImagem] = LerDocBMP(Arquivo,respInput)
 warning off;
 EstruturaImagem = struct( 'imagem',{0},...
                           'imagesize',{0},     'imageresolution',{0},...
                           'zunit',{0});
 escala = str2num(cell2mat(respInput(3))); 
 tamanho = str2num(cell2mat(respInput(1)));
 EstruturaImagem.zunit = cell2mat(respInput(2));
 [img map]= imread(Arquivo);
 resolucao=size(img);
 comprimento=min(resolucao(1:2));
 imgDb = im2double(img);
 if numel(resolucao)>2
      imagemConvert(:,:)=0.30 * imgDb(:,:,1) + 0.59 *imgDb(:,:,2) + 0.11 * imgDb(:,:,3);
 else
     imagemConvert=imgDb;
 end    
 EstruturaImagem.imagem = imagemConvert.*(escala/255);
 EstruturaImagem.imagem = EstruturaImagem.imagem.*(10^3);
 EstruturaImagem.imagesize = num2str((tamanho*comprimento)/300);
 EstruturaImagem.imageresolution = num2str(comprimento);
 
 clear imgBD;clear imagemConvert;clear map;clear img;clear tamanho;



%--------------------------------------------------------------------------

